/*
	File:		NewButtonPane.cp

	Contains:	Code to demonstrate new button types available with Appearance.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <2>	10/28/97	edv		Use RadioGroup control!
		 <1>	 9/11/97	edv		First checked in.
*/

#include "NewButtonPane.h"
#include "Appearance.h"
#include "AppearanceHelpers.h"
#include "UDialogUtils.h"

enum
{
	kBevel1			= 1,
	kToRightBevel	= 2,
	kBelowBevel 	= 3,
	kAboveBevel		= 4,
	kToLeftBevel	= 5,
	kMenuBevel		= 8,
	kMultiMenuBevel	= 9,
	kBevelGroup		= 18,
	kLeftJustBevel	= 19,
	kCenterJustBevel= 20,
	kRightJustBevel = 21,
	kFullJustBevel	= 22
};

#define MIN( a, b )		( ( (a) < (b) ) ? (a) : (b) )
#define MAX( a, b )		( ( (a) > (b) ) ? (a) : (b) )

NewButtonPane::NewButtonPane( DialogPtr dialog, SInt16 items ) : MegaPane( dialog, items )
{
	ControlHandle		control;
	Boolean				kTrue = true;
	SInt32				delay = 30;
	
	AppendDialogItemList( dialog, 6006, overlayDITL );
	
	GetDialogItemAsControl( dialog, fOrigItems + kToRightBevel, &control );
	SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceToRightOfGraphic );

	GetDialogItemAsControl( dialog, fOrigItems + kBelowBevel, &control );
	SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceBelowGraphic );

	GetDialogItemAsControl( dialog, fOrigItems + kAboveBevel, &control );
	SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceAboveGraphic );

	GetDialogItemAsControl( dialog, fOrigItems + kToLeftBevel, &control );
	SetBevelButtonTextPlacement( control, kControlBevelButtonPlaceToLeftOfGraphic );

	GetDialogItemAsControl( dialog, fOrigItems + kMenuBevel, &control );
	SetBevelButtonTextAlignment( control, kControlBevelButtonAlignTextFlushLeft, 3 );
	SetControlData( control, 0, 'pglc', sizeof( kTrue ), (Ptr)&kTrue );

	GetDialogItemAsControl( dialog, fOrigItems + kMultiMenuBevel, &control );
	SetBevelButtonTextAlignment( control, kControlBevelButtonAlignTextFlushLeft, 3 );
	SetControlData( control, 0, 'pglc', sizeof( kTrue ), (Ptr)&kTrue );

	GetDialogItemAsControl( dialog, fOrigItems + kMultiMenuBevel, &control );
	SetControlData( control, 0, kControlBevelButtonMenuDelayTag, sizeof( SInt32 ), (Ptr)&delay );
	
	InsertMenu( GetMenu( 147 ), -1 );
}

NewButtonPane::~NewButtonPane()
{
	ShortenDITL( fDialog, CountDITL( fDialog ) - fOrigItems );
}

void
NewButtonPane::ItemHit( SInt16 item )
{
	SInt16			localItem;
	
	localItem = item - fOrigItems;
	
	switch ( localItem )
	{
		case kMultiMenuBevel:
			{
				ControlHandle	control;
				Size			realSize;
				SInt16			menuID;
				
				GetDialogItemAsControl( fDialog, fOrigItems + kMultiMenuBevel, &control );
				GetControlData( control, 0, kControlBevelButtonLastMenuTag, sizeof( menuID ), (Ptr)&menuID, &realSize );
			}
			break;
	}
}
